local base = _G

module('me_menubar') -- top header&toolbar

local require = base.require
local ipairs = base.ipairs

local MapWindow					= require('me_map_window')
local DialogLoader				= require('DialogLoader')
local Menu						= require('Menu')
local MenuItem					= require('MenuItem')
local MenuBarItem				= require('MenuBarItem')
local Gui						= require('dxgui')
local AutoBriefingModule		= require('me_autobriefing')
local payload					= require('me_payload')
local MissionModule				= require('me_mission')
local Logbook					= require('me_logbook')
local i18n						= require('i18n')
local MsgWindow					= require('MsgWindow')
local NodesManager				= require('me_nodes_manager')
local TemplatesManager			= require('me_templates_manager')
local toolbar					= require('me_toolbar')
local panel_generator			= require('me_generator_dialog')
local panel_about				= require('me_about')
local panel_record_avi 			= require('record_avi')
local panel_campaign_editor 	= require('me_campaign_editor')
local panel_campaign			= require('me_campaign')
local MissionOptionsView		= require('Options.MissionOptionsView')
local OptionsDialog				= require('me_options')
local MapController				= require('Mission.MapController')
local MapLayerController		= require('Mission.MapLayerController')
local NavigationPointController	= require('Mission.NavigationPointController')
local AirdromeController 		= require('Mission.AirdromeController')
local waitScreen	        	= require('me_wait_screen')
local pPayload_vehicles		    = require('me_payload_vehicles')
local pPayload_ships		    = require('me_payload_ships')
local panel_server_list         = require('mul_server_list')  
local staticTemplate			= require('me_staticTemplate') 
local staticTemplateSave 		= require('me_staticTemplateSave') 
local staticTemplateLoad 		= require('me_staticTemplateLoad') 
local setCoordPanel 			= require('me_setCoordPanel')
local Terrain					= require('terrain')
local panelSelectUnit			= require('me_selectUnit')

i18n.setup(_M)

cdata = {
	missionEditor = _('MISSION EDITOR'),
	missionEditorLOFAC = _('MISSION EDITOR LOFAC'),
	yes	= _('YES'),
	no = _('NO'),
	cancel = _('CANCEL'),
	question = _('QUESTION'),
	
	-- menu items
	file = _('FILE'),
	new = _('NEW'),
	open = _('OPEN'),
	saveAs = _('SAVE AS'),
	exit = _('EXIT'),
	
	edit = _('EDIT-MEmenu', 'EDIT'),
	addAirplane = _('ADD AIRPLANE'),
	addHelicopter = _('ADD HELICOPTER'),
	addShip = _('ADD SHIP'),
	addVehicle = _('ADD VEHICLE'),
	addStatic = _('ADD STATIC'),
	addTemplate = _('ADD TEMPLATE'),
	remove = _('REMOVE'),
	
	flight = _('FLIGHT'),
	recordAvi = _('RECORD AVI'),
	replay = _('REPLAY-EDITOR', 'REPLAY'),
	
	campaign = _('CAMPAIGN'),
	campaignEditor = _('CAMPAIGN BUILDER'),
	
	customize = _('CUSTOMIZE'),
	
	mapOptions = _('MAP OPTIONS'),
	options = _('OPTIONS'),
    langPanel = _('LOCAL PANEL'),
	setPosition = _('SET POSITION'),
	
	generate = _('GENERATE...'),
	nodes = _('NODES'),
	templates = _('TEMPLATES'),
	save = _('SAVE'),

	help = _('MISC'),
	encyclopedia = _('ENCYCLOPEDIA'),
    trainingNetwork = _('TRAINING NETWORK'),
	
	loadStaticTemplate = _('LOAD STATIC TEMPLATE'),
	saveStaticTemplate = _('SAVE STATIC TEMPLATE'),
}

	
if base.LOFAC then
	cdata.about             = _('ABOUT MISSION EDITOR-LOFAC')
    cdata.generator         = _('MISSION GENERATOR MENU-LOFAC')
    cdata.missionOptions    = _('MISSION OPTIONS-LOFAC')
    cdata.flyMission        = _('FLY MISSION-LOFAC')
	cdata.prepareMission    = _('PREPARE MISSION-LOFAC')
    cdata.saveCahnges	= _(
        'Mission contains unsaved changes! All changes will be lost!\
        Press "Yes" to save your changes\
        Press "No" to discard and continue unsaved\
        Press "Cancel" to cancel flight-LOFAC')
	cdata.saveCahnges2	= _(
        'Mission contains unsaved changes! Your changes may be lost!\
        Press "Yes" to save your changes\
        Press "No" to quit without saving\
        Press "Cancel" to cancel-LOFAC')
	cdata.new_mission = _('Creating new mission-LOFAC')
	cdata.new_mission_msg = _('Are you sure you want to create new mission? \nAll unsaved changes will be lost!-LOFAC')
	cdata.open_mission_msg = _('Are you sure you want to open new mission? \nAll unsaved changes will be lost!-LOFAC')
    cdata.missionPlanner = _('MISSION PLANNER-LOFAC') 
    cdata.flight = _('STARTING THE EPISODES-LOFAC')
else
	cdata.about             = _('ABOUT MISSION EDITOR')
    cdata.generator         = _('MISSION GENERATOR MENU')
    cdata.missionOptions    = _('MISSION OPTIONS')
    cdata.flyMission        = _('FLY MISSION')
	cdata.prepareMission    = _('PREPARE MISSION')
    cdata.saveCahnges	= _(
        'Mission contains unsaved changes! All changes will be lost!\
        Press "Yes" to save your changes\
        Press "No" to discard and continue unsaved\
        Press "Cancel" to cancel flight')
	cdata.saveCahnges2	= _(
        'Mission contains unsaved changes! Your changes may be lost!\
        Press "Yes" to save your changes\
        Press "No" to quit without saving\
        Press "Cancel" to cancel')
	cdata.new_mission = _('Creating new mission')
	cdata.new_mission_msg = _('Are you sure you want to create new mission? \nAll unsaved changes will be lost!')
	cdata.open_mission_msg = _('Are you sure you want to open new mission? \nAll unsaved changes will be lost!')	 
    cdata.missionPlanner = _('MISSION PLANNER')
end

local x_, y_, w_, h_
local enabledSave = true

function create(x, y, w, h)
	x_ = x
	y_ = y
	w_ = w
	h_ = h
end

local function addWindowHotKeys()
	window:addHotKeyCallback('Ctrl+O', onOpen)
	window:addHotKeyCallback('Ctrl+N', onNew)
	window:addHotKeyCallback('Ctrl+S', onSave)
	window:addHotKeyCallback('Ctrl+P', function() onFly('--mission') end)
	window:addHotKeyCallback('Ctrl+W', onSetPosition)
	
	
	if base.LOFAC ~= true then
		window:addHotKeyCallback('Ctrl+M', function() onFly('--prepare') end)
	end
	
	window:addHotKeyCallback('Ctrl+R', onRecordAVI)	
	window:addHotKeyCallback('delete', onRemove)
end

local function setMenuCallback(menu)	
	function menu:onChange(item)
		if item.func then
			item.func()
		end
	end
end

local function setFileMenu()
	local menu = menuBar.file.menu
	
	setMenuCallback(menu)
	
	menu.new.func       = onNew
	menu.open.func      = onOpen
	menu.saveAs.func    = onSaveAs
    menu.save.func      = onSave
	menu.exit.func      = onExit
end

local function setEditMenu()
	local menu = menuBar.edit.menu
	
	setMenuCallback(menu)
	
	menu.addAirplane.func = onAddAirplane
	menu.addHelicopter.func = onAddHelicopter
	menu.addShip.func = onAddShip
	menu.addVehicle.func = onAddVehicle
	menu.addStatic.func = onAddStatic
	menu.addTemplate.func = onAddTemplate
	menu.remove.func = onRemove	
	menu.saveStaticTemplate.func = onSaveStaticTemplate
	menu.loadStaticTemplate.func = onLoadStaticTemplate
end


local function setFlightMenu()
	local menu = menuBar.flight.menu
	
	setMenuCallback(menu)
	
	menu.flyMission.func = function() onFly('--mission') end
	
	if base.LOFAC == true then
		menu:removeItem(menu.prepareMission)
		menu.prepareMission = nil
        menu.trainingNetwork.func = onNetworkTraining
	else
		menu.prepareMission.func = function() onFly('--prepare') end
        menu:removeItem(menu.trainingNetwork)
	end
	
	menu.recordAvi.func = onRecordAVI
	menu.replay.func = onShowReplays
        
end

local function setCampaignMenu()	
	if base.LOFAC then
		menuBar:removeItem(menuBar.campaign)
		menuBar.campaign = nil
	else
		local menu = menuBar.campaign.menu
		
		setMenuCallback(menu)
		
		menu.campaignEditor.func = onCampaignEditor
	end
end

local function setCustomizeMenu()
	local menu = menuBar.customize.menu
	
	setMenuCallback(menu)
	
	menu.missionOptions.func = onOptions
	menu.mapOptions.func = onMapOptions
    menu.langPanel.func = onLangPanel
	menu.setPosition.func = onSetPosition
	
	if base.LOFAC then
		menu.options.func = onLOFACOptions
	else
		menu:removeItem(menu.options)
		menu.options = nil
	end
end

local function setGeneratorMenu()
	local menu = menuBar.generator.menu
	local MGModule = require('me_generator')
	
	setMenuCallback(menu)
	
	menu.generate.func = onGeneratorDialog
	menu.nodes.func = onNodes
	menu.templates.func = onGeneratorTemplates
	menu.save.func = MGModule.saveAll
end

local function setHelpMenu()
	local menu = menuBar.help.menu
	
	setMenuCallback(menu)
	
	menu.encyclopedia.func = onEncyclopedia
	menu.about.func = onAbout
end

local function create_()
	window = DialogLoader.spawnDialogFromFile(base.dialogsDir .. "me_menubar.dlg", cdata)
	window:setBounds(x_, y_, w_, h_)

	staticCaption = window.staticCaption
	
	window.buttonClose.onChange = onChangeExit
	
	menuBar = window.menuBar
	
	setFileMenu()
	setEditMenu()
	setFlightMenu()
	setCampaignMenu()
	setCustomizeMenu()
	setGeneratorMenu()
	setHelpMenu()

	addWindowHotKeys()
end
	
function setEnabled(b)
	if (base.isPlannerMission() == false) then
		menuBar:setVisible(b)
	end
end

function setPlannerMission(planner_mission)
	if planner_mission == true then
		staticCaption:setText(cdata.missionPlanner)
		menuBar:setVisible(false)		
	else
		if base.LOFAC == true then
			staticCaption:setText(cdata.missionEditorLOFAC)
		else
			staticCaption:setText(cdata.missionEditor)
		end	
		
		menuBar:setVisible(true)
	end
	
	local layout = window:getLayout()
	
	if layout then
		layout:updateSize()
	end
end

	
function show(b)
	if not window then
		create_()
	end

    updateEnabledButtons()
	
	setPlannerMission(base.isPlannerMission())
	window:setVisible(b)
end

function showOnExitSavePrompt(yes, no, cancel)
	local result = cancel
	local handler = MsgWindow.question(cdata.saveCahnges2, cdata.question, yes, no, cancel)
	
	function handler:onChange(button)
		result = button
	end
	
	handler:show()
	
	return result
end

-- menu callbacks
function onExit()
	if MapWindow.isEmptyME() ~= true and MissionModule.isMissionModified() then
		local result = showOnExitSavePrompt(cdata.yes, cdata.no, cdata.cancel)
		
		if result == cdata.yes then
            toolbar.saveMission(true)
		elseif result == cdata.no then
			Exit()
		end
	else
	
		Exit()
	end
--	MapWindow.closeNewMapView()
end

function Exit()
    MapWindow.unselectAll()	
	if base.LOFAC then
		MapWindow.unselectAll()	
        toolbar.untoggle_all_except()
        MapController.onExit()
        hideME()
        base.START_PARAMS.command = '--quit'
        Gui.doQuit() 
		return
	end
	
	toolbar.untoggle_all_except()
    hideME()
	
    if MapWindow.isEmptyME() ~= true and MapWindow.isCreated() and (base.isPlannerMission() ~= true) then
        MapWindow.selectedGroup = nil
        MissionModule.create_new_mission()							
    end
	MapController.onExit()
	
	base.mmw.show(true)	
end 

function hideME()
    MapWindow.show(false)
	base.statusbar.show(false)
    base.mapInfoPanel.show(false)
	base.setCoordPanel.show(false)
	toolbar.show(false)
	base.panel_aircraft.show(false)
	base.panel_summary.show(false)
	base.panel_triggered_actions.show(false)
	base.panel_targeting.show(false)
    base.panel_paramFM.show(false)
	base.panel_radio.show(false)
	base.panel_route.show(false)
	base.panel_suppliers.show(false)
	base.panel_wpt_properties.show(false)
	base.panel_loadout.show(false)
    base.panel_wagons.show(false)
	base.panel_payload.show(false)
    pPayload_vehicles.show(false)
    pPayload_ships.show(false) -- uboats
	base.panel_ship.show(false)
	base.panel_vehicle.show(false)
	base.panel_static.show(false)
	base.panel_goal.showGoals(false)
	MissionOptionsView.hide()
	base.panel_openfile.show(false)
	panel_campaign.show(false)
	base.panel_briefing.show(false)
	base.panel_debriefing.show(false)
	base.panel_failures.show(false)
	base.panel_weather.show(false)
	OptionsDialog.hide()
	panel_about.show(false)
	panel_record_avi.hide()
	base.panel_template.show(false)
	NavigationPointController.hidePanel()
	AirdromeController.hideWarehousePanel()
    MapController.onToolbarTriggerZone(false)
	MapController.onToolbarTriggerZoneList(false)
    MapController.onToolbarMapOptions(false)
	show(false)
end
 
function onNew()
	toolbar.newMission()
end

function onOpen()
	toolbar.openMission()
end

function onSave()
	toolbar.saveMission()
end

function onSetPosition()
	setCoordPanel.show(not setCoordPanel:getVisible())
end

function onSaveAs()
	toolbar.untoggle_all_except()
	toolbar.saveMissionFileDialog()
end

function onManagerResource()
	base.panel_manager_resource.show(true)
end

function onAddAirplane()
	toolbar.addAirplane()
end

function onAddHelicopter()
	toolbar.addHelicopter()
end

function onAdd()
	toolbar.addVehicle()
end

function onNodes()
	NodesManager.show(true)
end

function onGeneratorTemplates()
	TemplatesManager.show(true)
end

function onGeneratorDialog()
	toolbar.untoggle_all_except()
    hideME()
	panel_generator.show(true, 'editor')
end

function onAddShip()
	toolbar.addShip()
end

function onAddVehicle()
	toolbar.addVehicle()
end

function onAddStatic()
	toolbar.addStatic()
end

function onAddTemplate()
	toolbar.addTemplate()
end

function onSaveStaticTemplate()
	staticTemplateSave.show(true)
--	staticTemplate.save()
end

function onLoadStaticTemplate()
	--staticTemplate.load()
	staticTemplateLoad.show(true)
end

function onRemove()
	MapController.onToolbarDelete()
	
	panelSelectUnit.show(false)

	local group
	
	if base.panel_static.window:isVisible() then
		group = base.panel_static.vdata.group
	elseif base.panel_ship.window:isVisible() then
		group = base.panel_ship.vdata.group
	elseif base.panel_vehicle.window:isVisible() then
		group = base.panel_vehicle.vdata.group
	elseif base.panel_aircraft.window:isVisible() then
		group = base.panel_aircraft.vdata.group
	end

	if group then
		MapWindow.setState(MapWindow.getPanState())
		MapWindow.selectedGroup = nil
		base.panel_units_list.saveSelection()
		base.module_mission.remove_group(group)
		
		if base.panel_units_list.window:isVisible() then		
			base.panel_units_list.selectNextGroup()
		else
			MapWindow.selectedGroup = nil
			toolbar.untoggle_all_except()
		end
	end
end

function onSelect()
	MapWindow.setState(MapWindow.getPanState())
end

function onFly(flight_type)
	toolbar.untoggle_all_except()	
	MapController.onFly()
	
	function showSavePrompt()
		local handler = MsgWindow.question(cdata.saveCahnges, cdata.question, cdata.yes, cdata.no, cdata.cancel)
		
		function handler:onChange(button)
            handler:hide()
			if button == cdata.yes then                
				toolbar.saveMission()
                Run(flight_type)
			elseif button == cdata.no then
				local path = MissionModule.getTempMissionPath()					
                
				if MissionModule.save_mission(path, false) then
					--MissionModule.mission.path = path
                    handler:close()
					Run(flight_type)
				end
			end
		end
		
		handler:show()
	end 
		
	if MissionModule.isMissionModified() or not MissionModule.getMissionPathIsSaved() then
		showSavePrompt()
    else
        Run(flight_type)
	end
end

function setEnabledSave(a_enable)
    enabledSave = a_enable 
    updateEnabledButtons()    
end

function updateEnabledButtons()
	if menuBar then
		if MapWindow.isEmptyME() == true then
			menuBar.edit:setEnabled(false)
			menuBar.flight:setEnabled(false)
			menuBar.file.menu.saveAs:setEnabled(false)
			menuBar.file.menu.save:setEnabled(false)
			
			menuBar.customize:setEnabled(false)
			
			menuBar.generator.menu.nodes:setEnabled(false)
			menuBar.generator.menu.templates:setEnabled(false)
			menuBar.generator.menu.save:setEnabled(false)

			
		else
			menuBar.edit:setEnabled(true)
			menuBar.flight:setEnabled(true)
			menuBar.file.menu.saveAs:setEnabled(enabledSave)
			menuBar.file.menu.save:setEnabled(enabledSave)
			
			menuBar.customize:setEnabled(true)
			
			menuBar.generator.menu.nodes:setEnabled(true)
			menuBar.generator.menu.templates:setEnabled(true)
			menuBar.generator.menu.save:setEnabled(true)
		end
	end
	
    
end

function Run(flight_type)
	AutoBriefingModule.returnToME = true
	AutoBriefingModule.fly = flight_type or '--mission'
	
	if '--prepare' == flight_type then 
		local path = MissionModule.mission.path or base.tempDataDir .. base.tempMissionName
		show(false)
		waitScreen.setUpdateFunction(function()
			if (MissionModule.play({ file = path, command = flight_type}, 'prepare', MissionModule.mission.path) == false) then
				show(true)
			end
		end)
	else
		base.panel_autobriefing.setDoSave(true)
		AutoBriefingModule.show(true, 'editor')
	end	
end 


function onNetworkTraining()
    MapWindow.unselectAll()	
    toolbar.untoggle_all_except()
	MapController.onExit()
    hideME()
    panel_server_list.show(true)
end

function onShowReplays()

	local handler = MsgWindow.question(cdata.saveCahnges, cdata.question, cdata.yes, cdata.no, cdata.cancel)
    
    function openReplays()
        hideME()
            
        waitScreen.setUpdateFunction(function()
			base.panel_openfile.show(true, 'editor', true)        
        end)
    end
		
    function handler:onChange(button)
        if button == cdata.yes then                
            toolbar.saveMissionFileDialog()
        end
        
        if button ~= cdata.cancel then                
            openReplays()
        end
    end
	
    if enabledSave == true then    
        handler:show()
    else
        openReplays()
    end    
end
	
function onRecordAVI()
	toolbar.untoggle_all_except()
	panel_record_avi.show()
end

function onOptions()
	toolbar.untoggle_all_except()
	MissionOptionsView.show()
end

function onLOFACOptions()
	waitScreen.setUpdateFunction(function()
		toolbar.untoggle_all_except()
		OptionsDialog.show()
	end)
end

function onMapOptions()
	toolbar.untoggle_all_except()
	MapLayerController.showMapLayerPanel()
end

function onLangPanel()
    toolbar.untoggle_all_except()
	base.langPanel.show(true)
end

function onEncyclopedia()
	toolbar.untoggle_all_except()
    hideME()
	base.panel_enc.show(true, true)
end

function onAbout()
	toolbar.untoggle_all_except()
	panel_about.show(true)
end

function onCampaignEditor()
	toolbar.untoggle_all_except()
    hideME()
	panel_campaign_editor.show(true, 'editor')
end

function onChangeExit()
	if (base.isPlannerMission() == true) then
		Exit()
		base.setPlannerMission(false)
		base.panel_autobriefing.setDoSave(true)
		base.panel_autobriefing.show(true, base.panel_autobriefing.returnScreen)
	else            
		onExit()
	end
end		